<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! class_exists('FCMNotification')) {
    class FCMNotification
    {
        private $apiUrl = 'https://fcm.googleapis.com/v1/projects/apps-edd2f/messages:send';
        private $serviceAccount;

        private $serviceAccountJson = '{
    "type": "service_account",
    "project_id": "apps-edd2f",
    "private_key_id": "ffae5ff891aa519f26eaacc6d4f517214bdf87d3",
    "private_key": "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCxXsIy2T1qTrYb\nqlrQAHqmc1i69MHzverOboSts7HoWHgXkGYQFiVygQGn4wo412Mg7mVu09Loq3eT\nUGmWmDAGNQqvuZg3EPZOuCA/aIStOFG9RmUym3+Co8mrSwvk4fglHdD9vprcN0kr\ntWmZooFzc9AnKV9oSBmkfuJ47Ntb6hEPUL8ZdbBuY8q94yNt56HHARI1ipZ0rdkV\nOylPlbgFCvXCjqSeNj9A6siMNGocwQo62Fhc9kMGasyeVFOq2VnPe1p/91B+/LaN\niapI8JXr0unkdoAt9CzrVB/j0h7+2TRcjIYApHxcmkUD6PNclcKoNkEqJiuvUvZX\nv2A+Q/YFAgMBAAECggEAH/93S1MTmE0Q31bRQTsE5Whjtn6XStCVPp6Dgw6q5r6n\nE6EyOG62XLzXPqFf47c/o94+IEtIfj8IuGPGWKul5kjFX8Q8qJp/xN3Eu4uwe8tw\nO5Qqh4Gz9C52IFfOkoENkiyZ2lz7dQToR2FX5qaBcgGPqLD3DEoNjjZxxtz8Cc2Y\nWT44h/Gtr+uGWwkr2TgAGhiCx3fj0VZQo1A3Y0BbSXgsaAUy6RskMPif0vtDX4Ss\nkx8oaRehqjlUvaiJ+pTy0Skut4dG6j/PoKXi02wjtxlTQB2vkxSZF8UWbyZmPM3i\nCvmhchgnShrtmmEtLFvx109jSUTQeGfbStPaqnUx4QKBgQDW07gkaOYexHWexIhI\n2FDBLG+nmNyXtxrTrUP4NYiPFpDaNEGI566zb4mEqT7GUJwILCx8gDABNYTLnsXG\n/X0tHWdQvClsvOvsP3Gh5FRAPbC2Em4B4DsvjzBp22agVbYsSlYXvsRT/3VErDav\n3nFDLsy4FCc0UHOyX/g8KW4ijQKBgQDTXUD1f2IKlMrv1RNANrXgiWfjprC9IL2n\n5WckjgHYc8LXf0hjs6B70GjZGproRJ6FYqsAu0bbmMDInWYnRmGfWCeSUChCLJTJ\nsFe/F4ccr2N6T+baDRtw2PaluScmghKfQOGboC6Nx5AaGkW6cO6OhHM+oTL1yQGz\nKVDtmK5/WQKBgHfOSUKc8cE05Teu+SZO5PJmWrqICHXf2uk0FtTk3gyWlB/sxqOY\nOZi+Wl4OmQC2Ud5I7GJehucVtsJsAHaSRe4UGNswpJWM4rG1TCTyFn5hKRzROGJ5\nb+h9HY3bmudOBbO7nTnO3OTPcdHjjPgVwOqrveXm71pAh9Vxqhm7LT29AoGAC6zG\n/ch/fd4iJ4U5fv6GpVRxrJ10fb3lO/Tr8ZT2fSJHzOd29Crj3nLwl61kiRfhObTt\nhSjTDSYu3+Xx0pGMquSPqwFKd/1Gaq2W6zM9f1QgxozLT5gRv/X8CcNkajgdFzba\nP2Jlr+cqCocQ+u9p/e1LAFafHfxwX5kUo0sfuGECgYEAj/qqVEcVC16vIKH55r0z\nhT2ZzBF7dOc9F0ZbBP21ktnjtdiQyIGzMcHITlS6yFgtaRRHA8+K4BAFJ4j1FCRU\n8yN1Ixqd/S+VibnCoEg5DDFcMGX803dGw4RfdtJ6Ryg/WRYHQdAvgiCRwSkfvJKC\nNYqN8G8RBG8zfn1sxGjD4HM=\n-----END PRIVATE KEY-----\n",
    "client_email": "firebase-adminsdk-tr3vu@apps-edd2f.iam.gserviceaccount.com",
    "client_id": "117679142228410605949",
    "auth_uri": "https://accounts.google.com/o/oauth2/auth",
    "token_uri": "https://oauth2.googleapis.com/token",
    "auth_provider_x509_cert_url": "https://www.googleapis.com/oauth2/v1/certs",
    "client_x509_cert_url": "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-tr3vu%40apps-edd2f.iam.gserviceaccount.com",
    "universe_domain": "googleapis.com"
}';

        public function __construct()
        {
            $this->serviceAccount = json_decode($this->serviceAccountJson, true);
        }

        public function sendByTopic($topic, $notification = [], $data = [], $priority = 'high')
        {
            $message = [
                'message' => [
                    'topic' => $topic,
                    'notification' => $notification,
                ]
            ];
            
            if (!empty($data) && is_array($data)) {
                $message['message']['data'] = $data;
            }

            return $this->sendNotification($message);
        }

        public function sendByToken($token, $notification = [], $data = [], $priority = 'high')
        {
            $message = [
                'message' => [
                    'token' => $token,
                    'notification' => $notification,
                ]
            ];
            
            if (!empty($data) && is_array($data)) {
                $message['message']['data'] = $data;
            }

            return $this->sendNotification($message);
        }

        private function sendNotification($message)
        {
            $token = $this->getAccessToken();

            $headers = [
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json',
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $this->apiUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // for localhost testing only
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));

            $response = curl_exec($ch);

            if ($response === false) {
                $error = 'FCM Send Error: ' . curl_error($ch);
                error_log($error, 3, 'fcm-error.log');
                curl_close($ch);
                return false;
            }

            curl_close($ch);
            return $response;
        }

        private function getAccessToken()
        {
            $now = time();
            $header = [
                'alg' => 'RS256',
                'typ' => 'JWT'
            ];
            $payload = [
                'iss' => $this->serviceAccount['client_email'],
                'sub' => $this->serviceAccount['client_email'],
                'aud' => 'https://oauth2.googleapis.com/token',
                'iat' => $now,
                'exp' => $now + 3600,
                'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
            ];

            $base64UrlHeader = $this->base64UrlEncode(json_encode($header));
            $base64UrlPayload = $this->base64UrlEncode(json_encode($payload));

            $signature = '';
            openssl_sign($base64UrlHeader . "." . $base64UrlPayload, $signature, $this->serviceAccount['private_key'], 'SHA256');

            $base64UrlSignature = $this->base64UrlEncode($signature);
            $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
                'assertion' => $jwt,
            ]));

            $result = curl_exec($ch);
            
            if ($result === false) {
                $error = 'OAuth Token Request Error: ' . curl_error($ch);
                error_log($error, 3, 'fcm-error.log');
                curl_close($ch);
                return false;
            }

            $response = json_decode($result, true);
            curl_close($ch);
            return $response['access_token'];
        }

        private function base64UrlEncode($data)
        {
            return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
        }
    }
}
